/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.renderer.entity.layers.MushroomCowMushroomLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.optifine.BetterGrass;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomItems;
import net.optifine.CustomLoadingScreens;
import net.optifine.CustomPanorama;
import net.optifine.CustomSky;
import net.optifine.EmissiveTextures;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartLeaves;
import net.optifine.TextureAnimations;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Shaders;
import net.optifine.util.StrUtils;
import net.optifine.util.TickableTexture;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static final String texGrassTop = "grass_block_top";
    private static final String texGrassSide = "grass_block_side";
    private static final String texGrassSideOverlay = "grass_block_side_overlay";
    private static final String texSnow = "snow";
    private static final String texGrassSideSnowed = "grass_block_snow";
    private static final String texMyceliumSide = "mycelium_side";
    private static final String texMyceliumTop = "mycelium_top";
    private static final String texWaterStill = "water_still";
    private static final String texWaterFlow = "water_flow";
    private static final String texLavaStill = "lava_still";
    private static final String texLavaFlow = "lava_flow";
    private static final String texFireLayer0 = "fire_0";
    private static final String texFireLayer1 = "fire_1";
    private static final String texSoulFireLayer0 = "soul_fire_0";
    private static final String texSoulFireLayer1 = "soul_fire_1";
    private static final String texCampFire = "campfire_fire";
    private static final String texCampFireLogLit = "campfire_log_lit";
    private static final String texSoulCampFire = "soul_campfire_fire";
    private static final String texSoulCampFireLogLit = "soul_campfire_log_lit";
    private static final String texPortal = "nether_portal";
    private static final String texGlass = "glass";
    private static final String texGlassPaneTop = "glass_pane_top";
    public static TextureAtlasSprite iconGrassTop;
    public static TextureAtlasSprite iconGrassSide;
    public static TextureAtlasSprite iconGrassSideOverlay;
    public static TextureAtlasSprite iconSnow;
    public static TextureAtlasSprite iconGrassSideSnowed;
    public static TextureAtlasSprite iconMyceliumSide;
    public static TextureAtlasSprite iconMyceliumTop;
    public static TextureAtlasSprite iconWaterStill;
    public static TextureAtlasSprite iconWaterFlow;
    public static TextureAtlasSprite iconLavaStill;
    public static TextureAtlasSprite iconLavaFlow;
    public static TextureAtlasSprite iconFireLayer0;
    public static TextureAtlasSprite iconFireLayer1;
    public static TextureAtlasSprite iconSoulFireLayer0;
    public static TextureAtlasSprite iconSoulFireLayer1;
    public static TextureAtlasSprite iconCampFire;
    public static TextureAtlasSprite iconCampFireLogLit;
    public static TextureAtlasSprite iconSoulCampFire;
    public static TextureAtlasSprite iconSoulCampFireLogLit;
    public static TextureAtlasSprite iconPortal;
    public static TextureAtlasSprite iconGlass;
    public static TextureAtlasSprite iconGlassPaneTop;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:block/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:item/";
    public static final ResourceLocation LOCATION_SPRITE_EMPTY;
    public static final ResourceLocation LOCATION_TEXTURE_EMPTY;
    public static final ResourceLocation WHITE_TEXTURE_LOCATION;
    private static IntBuffer staticBuffer;
    private static int glMaximumTextureSize;
    private static Map<Integer, String> mapTextureAllocations;

    static {
        LOCATION_SPRITE_EMPTY = new ResourceLocation("optifine/ctm/default/empty");
        LOCATION_TEXTURE_EMPTY = new ResourceLocation("optifine/ctm/default/empty.png");
        WHITE_TEXTURE_LOCATION = new ResourceLocation("textures/misc/white.png");
        staticBuffer = Config.createDirectIntBuffer(256);
        glMaximumTextureSize = -1;
        mapTextureAllocations = new HashMap<Integer, String>();
    }

    public static void update() {
        TextureAtlas textureatlas = TextureUtils.getTextureMapBlocks();
        if (textureatlas != null) {
            String s = SPRITE_PREFIX_BLOCKS;
            iconGrassTop = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texGrassTop);
            iconGrassSide = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texGrassSide);
            iconGrassSideOverlay = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texGrassSideOverlay);
            iconSnow = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texSnow);
            iconGrassSideSnowed = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texGrassSideSnowed);
            iconMyceliumSide = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texMyceliumSide);
            iconMyceliumTop = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texMyceliumTop);
            iconWaterStill = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texWaterStill);
            iconWaterFlow = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texWaterFlow);
            iconLavaStill = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texLavaStill);
            iconLavaFlow = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texLavaFlow);
            iconFireLayer0 = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texFireLayer0);
            iconFireLayer1 = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texFireLayer1);
            iconSoulFireLayer0 = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texSoulFireLayer0);
            iconSoulFireLayer1 = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texSoulFireLayer1);
            iconCampFire = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texCampFire);
            iconCampFireLogLit = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texCampFireLogLit);
            iconSoulCampFire = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texSoulCampFire);
            iconSoulCampFireLogLit = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texSoulCampFireLogLit);
            iconPortal = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texPortal);
            iconGlass = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texGlass);
            iconGlassPaneTop = TextureUtils.getSpriteCheck(textureatlas, String.valueOf(s) + texGlassPaneTop);
            String string = SPRITE_PREFIX_ITEMS;
        }
    }

    public static TextureAtlasSprite getSpriteCheck(TextureAtlas textureMap, String name) {
        TextureAtlasSprite textureatlassprite = textureMap.getUploadedSprite(name);
        if (textureatlassprite == null || textureatlassprite instanceof MissingTextureAtlasSprite) {
            Config.warn("Sprite not found: " + name);
        }
        return textureatlassprite;
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int j;
        int i;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (i = bi.getWidth()) == (j = bi.getHeight()) * 2) {
            BufferedImage bufferedimage = new BufferedImage(i, j * 2, 2);
            Graphics2D graphics2d = bufferedimage.createGraphics();
            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2d.drawImage(bi, 0, 0, i, j, null);
            return bufferedimage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i = 1;
        while (i < val) {
            i *= 2;
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int j = 0;
        while (i < val) {
            i *= 2;
            ++j;
        }
        return j;
    }

    public static int twoToPower(int power) {
        int i = 1;
        int j = 0;
        while (j < power) {
            i *= 2;
            ++j;
        }
        return i;
    }

    public static AbstractTexture getTexture(ResourceLocation loc) {
        AbstractTexture abstracttexture = Config.getTextureManager().getTexture(loc);
        if (abstracttexture != null) {
            return abstracttexture;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        abstracttexture = new SimpleTexture(loc);
        Config.getTextureManager().register(loc, abstracttexture);
        return abstracttexture;
    }

    public static void resourcesReloaded(ResourceManager rm) {
        if (TextureUtils.getTextureMapBlocks() != null) {
            Config.dbg("*** Reloading custom textures ***");
            CustomSky.reset();
            TextureAnimations.reset();
            TextureUtils.update();
            NaturalTextures.update();
            BetterGrass.update();
            BetterSnow.update();
            TextureAnimations.update();
            CustomColors.update();
            CustomSky.update();
            RandomEntities.update();
            CustomItems.updateModels();
            CustomEntityModels.update();
            Shaders.resourcesReloaded();
            Lang.resourcesReloaded();
            Config.updateTexturePackClouds();
            SmartLeaves.updateLeavesModels();
            CustomPanorama.update();
            CustomGuis.update();
            MushroomCowMushroomLayer.update();
            CustomLoadingScreens.update();
            CustomBlockLayers.update();
            Config.getTextureManager().tick();
            Config.dbg("Disable Forge light pipeline");
            ReflectorForge.setForgeLightPipelineEnabled(false);
        }
    }

    public static TextureAtlas getTextureMapBlocks() {
        return Config.getTextureMap();
    }

    public static void registerResourceListener() {
        ResourceManager resourcemanager = Config.getResourceManager();
        if (resourcemanager instanceof ReloadableResourceManager) {
            ReloadableResourceManager reloadableresourcemanager = (ReloadableResourceManager)resourcemanager;
            SimplePreparableReloadListener simplepreparablereloadlistener = new SimplePreparableReloadListener(){

                protected Object prepare(ResourceManager p_212854_1_, ProfilerFiller p_212854_2_) {
                    return null;
                }

                protected void apply(Object p_212853_1_, ResourceManager p_212853_2_, ProfilerFiller p_212853_3_) {
                }
            };
            reloadableresourcemanager.registerReloadListener(simplepreparablereloadlistener);
            ResourceManagerReloadListener resourcemanagerreloadlistener = new ResourceManagerReloadListener(){

                @Override
                public void onResourceManagerReload(ResourceManager resourceManager) {
                    TextureUtils.resourcesReloaded(resourceManager);
                }
            };
            reloadableresourcemanager.registerReloadListener(resourcemanagerreloadlistener);
        }
    }

    public static void registerTickableTextures() {
        TickableTexture tickabletexture = new TickableTexture(){

            @Override
            public void tick() {
                TextureAnimations.updateAnimations();
            }

            @Override
            public void load(ResourceManager var1) throws IOException {
            }

            @Override
            public int getId() {
                return 0;
            }

            @Override
            public void restoreLastBlurMipmap() {
            }

            @Override
            public MultiTexID getMultiTexID() {
                return null;
            }
        };
        ResourceLocation resourcelocation = new ResourceLocation("optifine/tickable_textures");
        Config.getTextureManager().register(resourcelocation, tickabletexture);
    }

    public static void registerCustomModels(ModelBakery modelBakery) {
        CustomItems.update();
        CustomItems.loadModels(modelBakery);
    }

    public static void registerCustomSprites(TextureAtlas textureMap) {
        if (textureMap.location().equals(TextureAtlas.LOCATION_BLOCKS)) {
            ConnectedTextures.updateIcons(textureMap);
            CustomItems.updateIcons(textureMap);
            BetterGrass.updateIcons(textureMap);
        }
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void refreshCustomSprites(TextureAtlas textureMap) {
        if (textureMap.location().equals(TextureAtlas.LOCATION_BLOCKS)) {
            ConnectedTextures.refreshIcons(textureMap);
            CustomItems.refreshIcons(textureMap);
            BetterGrass.refreshIcons(textureMap);
        }
        EmissiveTextures.refreshIcons(textureMap);
    }

    public static ResourceLocation fixResourceLocation(ResourceLocation loc, String basePath) {
        if (!loc.getNamespace().equals("minecraft")) {
            return loc;
        }
        String s = loc.getPath();
        String s1 = TextureUtils.fixResourcePath(s, basePath);
        if (s1 != s) {
            loc = new ResourceLocation(loc.getNamespace(), s1);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String s = "assets/minecraft/";
        if (path.startsWith(s)) {
            return path.substring(s.length());
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = String.valueOf(basePath) + "/";
            }
            return String.valueOf(basePath) + path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String s1 = "optifine/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            return String.valueOf(s1) + path;
        }
        return path.startsWith("/") ? String.valueOf(s1) + path.substring(1) : path;
    }

    public static String getBasePath(String path) {
        int i = path.lastIndexOf(47);
        return i < 0 ? "" : path.substring(0, i);
    }

    public static void applyAnisotropicLevel() {
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float f = GL11.glGetFloat((int)34047);
            float f1 = Config.getAnisotropicFilterLevel();
            f1 = Math.min(f1, f);
            GL11.glTexParameterf((int)3553, (int)34046, (float)f1);
        }
    }

    public static void bindTexture(int glTexId) {
        GlStateManager._bindTexture(glTexId);
    }

    public static boolean isPowerOfTwo(int x) {
        int i = Mth.smallestEncompassingPowerOfTwo(x);
        return i == x;
    }

    public static NativeImage scaleImage(NativeImage ni, int w2) {
        BufferedImage bufferedimage = TextureUtils.toBufferedImage(ni);
        BufferedImage bufferedimage1 = TextureUtils.scaleImage(bufferedimage, w2);
        return TextureUtils.toNativeImage(bufferedimage1);
    }

    public static BufferedImage toBufferedImage(NativeImage ni) {
        int i = ni.getWidth();
        int j = ni.getHeight();
        int[] aint = new int[i * j];
        ni.getBufferRGBA().get(aint);
        BufferedImage bufferedimage = new BufferedImage(i, j, 2);
        bufferedimage.setRGB(0, 0, i, j, aint, 0, i);
        return bufferedimage;
    }

    private static NativeImage toNativeImage(BufferedImage bi) {
        int i = bi.getWidth();
        int j = bi.getHeight();
        int[] aint = new int[i * j];
        bi.getRGB(0, 0, i, j, aint, 0, i);
        NativeImage nativeimage = new NativeImage(i, j, false);
        nativeimage.getBufferRGBA().put(aint);
        return nativeimage;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int i = bi.getWidth();
        int j = bi.getHeight();
        int k = j * w2 / i;
        BufferedImage bufferedimage = new BufferedImage(w2, k, 2);
        Graphics2D graphics2d = bufferedimage.createGraphics();
        Object object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < i || w2 % i != 0) {
            object = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2d.drawImage(bi, 0, 0, w2, k, null);
        return bufferedimage;
    }

    public static int scaleToGrid(int size, int sizeGrid) {
        if (size == sizeGrid) {
            return size;
        }
        int i = size / sizeGrid * sizeGrid;
        while (i < size) {
            i += sizeGrid;
        }
        return i;
    }

    public static int scaleToMin(int size, int sizeMin) {
        if (size >= sizeMin) {
            return size;
        }
        int i = sizeMin / size * size;
        while (i < sizeMin) {
            i += size;
        }
        return i;
    }

    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(suffix);
        while (iterator.hasNext()) {
            Dimension dimension;
            ImageReader imagereader = iterator.next();
            try {
                try {
                    ImageInputStream imageinputstream = ImageIO.createImageInputStream(in);
                    imagereader.setInput(imageinputstream);
                    int i = imagereader.getWidth(imagereader.getMinIndex());
                    int j = imagereader.getHeight(imagereader.getMinIndex());
                    dimension = new Dimension(i, j);
                }
                catch (IOException ioexception) {
                    imagereader.dispose();
                    continue;
                }
            }
            catch (Throwable throwable) {
                imagereader.dispose();
                throw throwable;
            }
            imagereader.dispose();
            return dimension;
        }
        return null;
    }

    public static void dbgMipmaps(TextureAtlasSprite textureatlassprite) {
        NativeImage[] anativeimage = textureatlassprite.getMipmapImages();
        int i = 0;
        while (i < anativeimage.length) {
            NativeImage nativeimage = anativeimage[i];
            if (nativeimage == null) {
                Config.dbg(String.valueOf(i) + ": " + nativeimage);
            } else {
                Config.dbg(String.valueOf(i) + ": " + nativeimage.getWidth() * nativeimage.getHeight());
            }
            ++i;
        }
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels, int width, int height) {
        TextureUtils.bindTexture(textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        name = StrUtils.removeSuffix(name, ".png");
        File file1 = new File(name);
        File file2 = file1.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        int i = 0;
        while (i < 16) {
            String s = String.valueOf(name) + "_" + i + ".png";
            File file3 = new File(s);
            file3.delete();
            ++i;
        }
        int l = 0;
        while (l <= mipmapLevels) {
            File file4 = new File(String.valueOf(name) + "_" + l + ".png");
            int i1 = width >> l;
            int j = height >> l;
            int k = i1 * j;
            IntBuffer intbuffer = BufferUtils.createIntBuffer((int)k);
            int[] aint = new int[k];
            GL11.glGetTexImage((int)3553, (int)l, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.get(aint);
            BufferedImage bufferedimage = new BufferedImage(i1, j, 2);
            bufferedimage.setRGB(0, 0, i1, j, aint, 0, i1);
            try {
                ImageIO.write((RenderedImage)bufferedimage, "png", file4);
                Config.dbg("Exported: " + file4);
            }
            catch (Exception exception) {
                Config.warn("Error writing: " + file4);
                Config.warn(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
            ++l;
        }
    }

    public static int getGLMaximumTextureSize() {
        if (glMaximumTextureSize < 0) {
            glMaximumTextureSize = TextureUtils.detectGLMaximumTextureSize();
        }
        return glMaximumTextureSize;
    }

    private static int detectGLMaximumTextureSize() {
        int i = 65536;
        while (i > 0) {
            GlStateManager._texImage2D(32868, 0, 6408, i, i, 0, 6408, 5121, null);
            int j = GL11.glGetError();
            int k = GlStateManager._getTexLevelParameter(32868, 0, 4096);
            if (k != 0) {
                return i;
            }
            i >>= 1;
        }
        return 0;
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage1;
        if (imageStream == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage;
            bufferedimage1 = bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
        return bufferedimage1;
    }

    public static int toAbgr(int argb) {
        int i = argb >> 24 & 0xFF;
        int j = argb >> 16 & 0xFF;
        int k = argb >> 8 & 0xFF;
        int l = argb >> 0 & 0xFF;
        return i << 24 | l << 16 | k << 8 | j;
    }

    public static void resetDataUnpacking() {
        GlStateManager._pixelStore(3314, 0);
        GlStateManager._pixelStore(3316, 0);
        GlStateManager._pixelStore(3315, 0);
        GlStateManager._pixelStore(3317, 4);
    }

    public static String getStackTrace(Throwable t) {
        CharArrayWriter chararraywriter = new CharArrayWriter();
        t.printStackTrace(new PrintWriter(chararraywriter));
        return chararraywriter.toString();
    }

    public static void debugTextureGenerated(int id) {
        mapTextureAllocations.put(id, TextureUtils.getStackTrace(new Throwable("StackTrace")));
        Config.dbg("Textures: " + mapTextureAllocations.size());
    }

    public static void debugTextureDeleted(int id) {
        mapTextureAllocations.remove(id);
        Config.dbg("Textures: " + mapTextureAllocations.size());
    }
}

