/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;
import net.optifine.reflect.Reflector;
import net.optifine.util.IntegratedServerUtils;

public class TileEntityUtils {
    public static String getTileEntityName(BlockGetter blockAccess, BlockPos blockPos) {
        BlockEntity blockentity = blockAccess.getBlockEntity(blockPos);
        return TileEntityUtils.getTileEntityName(blockentity);
    }

    public static String getTileEntityName(BlockEntity te) {
        if (!(te instanceof Nameable)) {
            return null;
        }
        Nameable nameable = (Nameable)((Object)te);
        TileEntityUtils.updateTileEntityName(te);
        return !nameable.hasCustomName() ? null : nameable.getCustomName().getContents();
    }

    public static void updateTileEntityName(BlockEntity te) {
        BlockPos blockpos = te.getBlockPos();
        Component component = TileEntityUtils.getTileEntityRawName(te);
        if (component == null) {
            Component component1 = TileEntityUtils.getServerTileEntityRawName(blockpos);
            if (component1 == null) {
                component1 = new TextComponent("");
            }
            TileEntityUtils.setTileEntityRawName(te, component1);
        }
    }

    public static Component getServerTileEntityRawName(BlockPos blockPos) {
        BlockEntity blockentity = IntegratedServerUtils.getTileEntity(blockPos);
        return blockentity == null ? null : TileEntityUtils.getTileEntityRawName(blockentity);
    }

    public static Component getTileEntityRawName(BlockEntity te) {
        if (te instanceof Nameable) {
            return ((Nameable)((Object)te)).getCustomName();
        }
        return te instanceof BeaconBlockEntity ? (Component)Reflector.getFieldValue(te, Reflector.TileEntityBeacon_customName) : null;
    }

    public static boolean setTileEntityRawName(BlockEntity te, Component name) {
        if (te instanceof BaseContainerBlockEntity) {
            ((BaseContainerBlockEntity)te).setCustomName(name);
            return true;
        }
        if (te instanceof BannerBlockEntity) {
            ((BannerBlockEntity)te).setCustomName(name);
            return true;
        }
        if (te instanceof EnchantmentTableBlockEntity) {
            ((EnchantmentTableBlockEntity)te).setCustomName(name);
            return true;
        }
        if (te instanceof BeaconBlockEntity) {
            ((BeaconBlockEntity)te).setCustomName(name);
            return true;
        }
        return false;
    }
}

